/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.event;

import io.github.thecsdev.tcdcommons.api.event.TKeyedEvent;
import java.util.LinkedHashMap;
import java.util.Objects;

final class TKeyedEventImpl<T>
implements TKeyedEvent<T> {
    private final LinkedHashMap<String, T> listeners;
    private final T invoker;

    public TKeyedEventImpl(LinkedHashMap<String, T> listeners, T invoker) {
        this.listeners = Objects.requireNonNull(listeners);
        this.invoker = Objects.requireNonNull(invoker);
    }

    @Override
    public boolean register(String key, T listener) {
        if (key == null || listener == null || this.isRegistered(key)) {
            return false;
        }
        if (this.listeners.put(key, listener) == null) {
            // empty if block
        }
        return true;
    }

    @Override
    public boolean unregister(String key) {
        return this.listeners.remove(key) != null;
    }

    @Override
    public boolean isRegistered(String key) {
        return this.listeners.containsKey(key);
    }

    @Override
    public void clearListeners() {
        this.listeners.clear();
    }

    @Override
    public T invoker() {
        return this.invoker;
    }
}

